--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: San Jose
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "sj_marketkeep" }
DefineCharacter { name = "sj_farmkeep" }
DefineCharacter { name = "sj_shopkeep" }
DefineCharacter { name = "sj_otherkeep" }
-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "sanjose",
	available = false,
	ambient = "sfx/remote_loop.ogg",

	layout =
	{
		
		
		-- TODO: Volcano Spew
	
		SpriteLayer { image="sj_volcano", x=529+246/2,y=33+65/2, },
		
		-- Clouds
		SpriteLayer { image="clouds_03", time=200000, loop=true, htile=true, path={{0,50},{100,50},{700,50},{800,50}}, },
		
		Market { name="sj_farm", character="sj_farmkeep", x=0+176/2,y=125+74/2,
			ambient = "sfx/farm_loop.ogg",
			inventory = { sj_cacao=true}, dialog="farm_sanjose", },
		EmptyBuilding { name="sj_other", character={"sj_otherkeep"}, x=326+225/2,y=132+128/2, },
		
		-- Perspective cars
		SpriteLayer { image="car_07", near=250,nearscale=.55, far=197,farscale=0.1,
			path={{458,236},{448,223},{436,209},{424,197},}, },
		
		Market { name="sj_market", character="sj_marketkeep", x=117+229/2,y=127+121/2,
			inventory = {cacao = true, milk=true, sugar=true, cashew=true,  } },
		SpriteLayer { image="sj_marketmask", x=0+373/2,y=171+126/2, },
		Shop { name="sj_shop", character="sj_shopkeep", x=536+137/2,y=124+125/2, },
		
		SpriteLayer { image="sj_shopmask", x=621+99/2,y=131+135/2, },
		
		-- Front cars
		SpriteLayer { imagelist=portCars, scale=.55, time=6000,
			path={{-80,245},{530,245},{580,245},{880,245}} },
		SpriteLayer { imagelist=portCars, scale=.55,time=8000,
			path={{880,257},{580,257},{530,257},{-80,257}} },
		
		--  Front car mask
		SpriteLayer { image="sj_leftmask", x=0+320/2,y=196+78/2 },
		SpriteLayer { image="sj_midmask", x=322+274/2,y=264+9/2 },
		SpriteLayer { image="sj_rightmask", x=603+197/2,y=200+73/2 },
	
		
		-- Waterfall
		SpriteLayer { image="waterfall.xml", hflip=true, scale=2.0, x=150,y=316},
		SpriteLayer { image="sj_waterfallmask", x=179,y=325 },
		
	}
}
